#!/usr/bin/env python
# Copy Selection to Clipboard

# Copyright 2004 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041217 - first version of this script

# s = self.GetItemText(item)
# cbData = wxPyTextDataObject()
# cbData.SetText(s)
# 
# if wxTheClipboard.Open():
#     wxTheClipboard.SetData(cbData)
#     wxTheClipboard.Flush()
#     wxTheClipboard.Close()

import os

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def CopyToClipboard(self):
    rid = self.ReportID  # current report
    if rid == 1:
        hint("This script doesn't work on the main report.")
        return  # do nothing

    # find selection
    selcol = self.Report.GetSelectedCols()  # current selection

    selrow = self.Report.GetSelectedRows()  # current selection
    selcell = self.Report.GetSelectedCells()  # current selection
    selr = self.Report.GetGridCursorRow()  # current selection
    selc = self.Report.GetGridCursorCol()  # current selection
    seltl = self.Report.GetSelectionBlockTopLeft()  # current selection
    selbr = self.Report.GetSelectionBlockBottomRight()  # current selection

    if debug:
        print 'selcol', selcol
        print 'selrow', selrow
        print 'selcell', selcell
        print 'cursor', selr, selc
        print 'seltl', seltl
        print 'selbr', selbr

    cx = self.Report.table.columns
    ox = self.Report.table.coloffset
    rx = self.Report.table.rows
    if not (cx and rx):
        hint("There are no cells to copy yet.")
        return

    if selcol: # columns selected
        r = range(len(rx))
        c = selcol
    elif selrow:
        r = selrow
        c = range(len(cx))
    elif seltl and selbr:
        r = range(seltl[0][0], selbr[0][0] + 1)
        c = range(seltl[0][1], selbr[0][1] + 1)
    else:
        r = [ selr ]
        c = [ selc ]

    def stringval(x):
        if isinstance(x, int) or isinstance(x, float):
            return str(x)
        elif isinstance(x, str):
            if x.count('\t'): x = x.replace('\t', r'\t')
            if x.count('\n'): x = x.replace('\n', r'\n')
            if x.count('\r'): x = x.replace('\r', r'\r')
            return x
        else:
            return x

    values = [ [ stringval(Data.GetCellValue(rx[ri], cx[ci], ox[ci])) for ci in c ] for ri in r ]

    print values

    s = os.linesep.join( [ '\t'.join(row) for row in values ] )  

    if len(values) > 1 or len(values[0]) > 1:
        s += os.linesep

    print s
  
    # s = 'for the clipboard\tmore\tmore' + os.linesep + '1\t2\t3'
    # s = 'for the clipboard\tmore\tmore' + '\r' + '1\t2\t3' + '\r'
    cbData = wx.PyTextDataObject()
    cbData.SetText(s)

    if wx.TheClipboard.Open():
        wx.TheClipboard.SetData(cbData)
        wx.TheClipboard.Flush()
        wx.TheClipboard.Close()

CopyToClipboard(self)
